/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.ShellValidationSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsRegistryIterator;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.windows.PathConverter;
import org.netbeans.modules.nativeexecution.support.windows.SimpleConverter;
import org.openide.util.Utilities;

public final class WindowsSupport {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final Object initLock = new Object();
    private static WindowsSupport instance;
    private boolean initialized = false;
    private Shell activeShell = null;
    private PathConverter pathConverter = null;
    private AtomicReference<String> pathKeyRef = new AtomicReference();
    private Charset charset;

    private WindowsSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WindowsSupport getInstance() {
        Object object = initLock;
        synchronized (object) {
            if (instance == null) {
                instance = new WindowsSupport();
            }
            if (!WindowsSupport.instance.initialized) {
                instance.init();
            }
            return instance;
        }
    }

    public String getShell() {
        return this.activeShell == null ? null : this.activeShell.shell;
    }

    public void init() {
        this.init(null);
        if (Utilities.isWindows()) {
            if (this.activeShell == null) {
                log.fine("WindowsSupport: no shell found");
            } else {
                log.log(Level.FINE, "WindowsSupport: found {0} shell in {1}", new Object[]{this.activeShell.type, this.activeShell.bindir.getAbsolutePath()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String searchDir) {
        Object object = initLock;
        synchronized (object) {
            if (!Utilities.isWindows()) {
                return;
            }
            this.pathConverter = new SimpleConverter();
            this.activeShell = this.findShell(searchDir);
            this.initCharset();
            this.initialized = true;
        }
    }

    private Shell findShell(String searchDir) {
        String[] msysRegKeys;
        Shell shell;
        String[][] cygwinRegKeys;
        Shell candidate = null;
        for (String[] regKey : cygwinRegKeys = new String[][]{{"SOFTWARE\\cygwin\\setup", "rootdir", ".*rootdir.*REG_SZ(.*)"}, {"SOFTWARE\\Wow6432Node\\cygwin\\setup", "rootdir", ".*rootdir.*REG_SZ(.*)"}, {"SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\/", "native", ".*native.*REG_SZ(.*)"}, {"SOFTWARE\\Wow6432Node\\Cygnus Solutions\\Cygwin\\mounts v2\\/", "native", ".*native.*REG_SZ(.*)"}}) {
            shell = this.initShell(Shell.ShellType.CYGWIN, this.queryWindowsRegistry(regKey[0], regKey[1], regKey[2]));
            if (shell == null) continue;
            return shell;
        }
        for (String regKey : msysRegKeys = new String[]{"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MSYS-1.0_is1", "SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MSYS-1.0_is1"}) {
            shell = this.initShell(Shell.ShellType.MSYS, this.queryWindowsRegistry(regKey, "Inno Setup: App Path", ".*REG_SZ(.*)"));
            if (shell == null) continue;
            return shell;
        }
        Object paths = System.getenv("PATH");
        if (searchDir != null && searchDir.length() > 0) {
            paths = searchDir + ";" + (String)paths;
        }
        if (paths != null) {
            for (String path : ((String)paths).split(";")) {
                ShellValidationSupport.ShellValidationStatus validationStatus;
                File sh = new File(path, "bash.exe");
                if (!sh.exists() || !sh.canRead()) {
                    sh = new File(path, "sh.exe");
                }
                File parent = sh.getParentFile();
                if (!sh.exists() || !sh.canRead() || !"bin".equals(parent.getName())) continue;
                if (new File(parent, "msysinfo").exists()) {
                    return new Shell(Shell.ShellType.MSYS, sh.getAbsolutePath(), parent);
                }
                if (new File(parent, "msys-2.0.dll").exists()) {
                    return new Shell(Shell.ShellType.MSYS, sh.getAbsolutePath(), parent);
                }
                if (new File(parent, "cygwin1.dll").exists()) {
                    return new Shell(Shell.ShellType.CYGWIN, sh.getAbsolutePath(), parent);
                }
                if (!new File(parent, "cygcheck.exe").exists()) continue;
                if (candidate == null) {
                    candidate = new Shell(Shell.ShellType.CYGWIN, sh.getAbsolutePath(), parent);
                }
                if (!(validationStatus = ShellValidationSupport.getValidationStatus(candidate)).isValid() || validationStatus.hasWarnings()) continue;
                return candidate;
            }
        }
        return candidate;
    }

    public int getWinPID(int shellPID) {
        ProcessBuilder pb;
        if (this.activeShell == null) {
            return shellPID;
        }
        File psFile = new File(this.activeShell.bindir, "ps.exe");
        if (!psFile.exists()) {
            return shellPID;
        }
        String psCommand = psFile.getAbsolutePath();
        switch (this.activeShell.type) {
            case CYGWIN: {
                pb = new ProcessBuilder(psCommand, "-W", "-p", Integer.toString(shellPID));
                break;
            }
            case MSYS: {
                pb = new ProcessBuilder(psCommand, "-W");
                break;
            }
            default: {
                return shellPID;
            }
        }
        ProcessUtils.ExitStatus res = ProcessUtils.execute(pb);
        List<String> output = res.getOutputLines();
        Pattern pat = Pattern.compile("[I]*[\t ]*([0-9]+)[\t ]*([0-9]+)[\t ]*([0-9]+)[\t ]*([0-9]+).*");
        for (String s : output) {
            Integer pid;
            Matcher m = pat.matcher(s);
            if (!m.matches() || (pid = Integer.valueOf(Integer.parseInt(m.group(1)))) != shellPID) continue;
            return Integer.parseInt(m.group(4));
        }
        return shellPID;
    }

    private String queryWindowsRegistry(String key, String param, String regExpr) {
        WindowsRegistryIterator registryIterator = WindowsRegistryIterator.get(key, param);
        Pattern pattern = Pattern.compile(regExpr);
        while (registryIterator.hasNext()) {
            String[] output = registryIterator.next();
            if (output == null) continue;
            for (String line : output) {
                Matcher m = pattern.matcher(line);
                if (!m.matches()) continue;
                return m.group(1).trim();
            }
        }
        return null;
    }

    public String convertToCygwinPath(String winPath) {
        return this.convert(PathConverter.PathType.WINDOWS, PathConverter.PathType.CYGWIN, winPath, true);
    }

    public String convertFromCygwinPath(String cygwinPath) {
        return this.convert(PathConverter.PathType.CYGWIN, PathConverter.PathType.WINDOWS, cygwinPath, true);
    }

    public String convertToMSysPath(String winPath) {
        return this.convert(PathConverter.PathType.WINDOWS, PathConverter.PathType.MSYS, winPath, true);
    }

    public String convertFromMSysPath(String msysPath) {
        return this.convert(PathConverter.PathType.MSYS, PathConverter.PathType.WINDOWS, msysPath, true);
    }

    public String convertToShellPath(String path) {
        return this.activeShell == null ? null : this.convert(PathConverter.PathType.WINDOWS, this.activeShell.type.toPathType(), path, true);
    }

    public String convertToWindowsPath(String path) {
        return this.activeShell == null ? null : this.convert(this.activeShell.type.toPathType(), PathConverter.PathType.WINDOWS, path, true);
    }

    public String convertToAllShellPaths(String paths) {
        return this.activeShell == null ? null : this.convert(PathConverter.PathType.WINDOWS, this.activeShell.type.toPathType(), paths, false);
    }

    private String convert(PathConverter.PathType from, PathConverter.PathType to, String path, boolean isSinglePath) {
        if (to == null || from == null) {
            return null;
        }
        if (!(from != PathConverter.PathType.CYGWIN && to != PathConverter.PathType.CYGWIN || this.activeShell != null && this.activeShell.type == Shell.ShellType.CYGWIN)) {
            return null;
        }
        return isSinglePath ? this.pathConverter.convert(from, to, path) : this.pathConverter.convertAll(from, to, path);
    }

    public Charset getShellCharset() {
        return this.charset;
    }

    private Shell initShell(Shell.ShellType type, String root) {
        if (root == null) {
            return null;
        }
        File sh = new File(root + "/bin/bash.exe");
        if (!sh.exists() || !sh.canRead()) {
            sh = new File(root + "/bin/sh.exe");
        }
        if (!sh.exists() || !sh.canRead()) {
            return null;
        }
        return new Shell(type, sh.getAbsolutePath(), sh.getParentFile().getAbsoluteFile());
    }

    public Shell getActiveShell() {
        return this.activeShell;
    }

    private void initCharset() {
        this.charset = Charset.defaultCharset();
        if (this.activeShell == null || this.activeShell.type != Shell.ShellType.CYGWIN) {
            return;
        }
        try {
            ProcessUtils.ExitStatus result = ProcessUtils.execute(new ProcessBuilder(this.activeShell.shell, "--login", "-c", "echo $LANG"));
            if (result.isOK()) {
                String shellOutput = result.getOutputString();
                int dotIndex = shellOutput.indexOf(46);
                if (dotIndex >= 0) {
                    shellOutput = shellOutput.substring(dotIndex + 1).trim();
                }
                try {
                    this.charset = Charset.forName(shellOutput);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String cygwinVersion = null;
            ProcessBuilder pb = new ProcessBuilder(this.activeShell.bindir + "\\uname.exe", "-r");
            ProcessUtils.ExitStatus res = ProcessUtils.execute(pb);
            String output = res.getOutputString();
            Pattern p = Pattern.compile("^([0-9\\.]*).*");
            Matcher m = p.matcher(output);
            if (m.matches()) {
                cygwinVersion = m.group(1);
            }
            if (cygwinVersion == null) {
                return;
            }
            if (cygwinVersion.startsWith("1.7")) {
                this.charset = StandardCharsets.UTF_8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPathKey() {
        if (this.pathKeyRef.get() == null) {
            ProcessBuilder pb = new ProcessBuilder("");
            String pathKey = "PATH";
            for (String key : pb.environment().keySet()) {
                if (!"PATH".equalsIgnoreCase(key)) continue;
                pathKey = key;
                break;
            }
            this.pathKeyRef.compareAndSet(null, pathKey);
        }
        return this.pathKeyRef.get();
    }
}

